<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

class SessionManager {

	static function sessionStart($name, $limit = 0, $path = '/', $domain = null, $secure = null)
	{

		global $HTTPS;

		session_set_cookie_params(
			0, 
			"/", 
			"", 
			$HTTPS, 
			true
		);

		session_start();

		//check for control variable
		if (!isset($_SESSION["STB_SESS_CHECK"])) {
		    session_regenerate_id(true);

			$_SESSION["STB_SESS_CHECK"] = array(
				"start"	=> time(),
				"IP"	=> $_SERVER["REMOTE_ADDR"],
				"agent"	=> $_SERVER['HTTP_USER_AGENT'],
			);

		}


		//check if ip is different then the last one
		if (($_SESSION['STB_SESS_CHECK']['IP'] !== $_SERVER['REMOTE_ADDR']) || ($_SESSION['STB_SESS_CHECK']['agent'] !== $_SERVER['HTTP_USER_AGENT'])) {
			session_regenerate_id(true);
			// Delete everything:
			$_SESSION = array();

			$_SESSION["STB_SESS_CHECK"] = array(
				"start"	=> time(),
				"IP"	=> $_SERVER["REMOTE_ADDR"],
				"agent"	=> $_SERVER['HTTP_USER_AGENT'],
			);
		}
		
		//regenerate if session older then 5 minutes
		if ($_SESSION['STB_SESS_CHECK']['start'] < time() - 300) {
			session_regenerate_id(true);
			$_SESSION['STB_SESS_CHECK']['start'] = time();
		}

	}
}



?>